package com.example.item;

import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.registry.CompostingChanceRegistry;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.minecraft.component.type.FoodComponent;
import net.minecraft.entity.effect.StatusEffectInstance;
import net.minecraft.entity.effect.StatusEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemGroups;
import net.minecraft.item.ItemStack;
import net.minecraft.registry.Registries;
import net.minecraft.registry.Registry;
import net.minecraft.registry.RegistryKey;
import net.minecraft.registry.RegistryKeys;
import net.minecraft.text.Text;
import net.minecraft.util.Identifier;

public class ModItems {
    public static final FoodComponent SPEED_FOOD_COMPONENT = new FoodComponent.Builder()
            .alwaysEdible()
            .nutrition(1)
            .saturationModifier(1f)
            .snack()
            .statusEffect(new StatusEffectInstance(StatusEffects.SPEED, 5 * 20, 1), 1f)
            .statusEffect(new StatusEffectInstance(StatusEffects.NAUSEA, 10 * 20, 1), 0.1f)
            .build();

    public static final Item MAGIC_DUST = register(
            new Item(new Item.Settings().maxCount(16).food(SPEED_FOOD_COMPONENT)),
            "magic_dust"
    );

    public static final LightningStick LIGHTNING_STICK = (LightningStick) register(
            new LightningStick(new Item.Settings().maxCount(1)),
            "lightning_stick"
    );

    public static final RegistryKey<ItemGroup> CUSTOM_ITEM_GROUP_KEY = RegistryKey.of(
            RegistryKeys.ITEM_GROUP,
            Identifier.of(CustomItem.MOD_ID, "item_group")
    );

    public static final ItemGroup CUSTOM_ITEM_GROUP = FabricItemGroup.builder()
            .icon(() -> new ItemStack(ModItems.MAGIC_DUST))
            .displayName(Text.translatable("itemGroup.custom-item"))
            .build();

    public static void initialize() {
        Registry.register(Registries.ITEM_GROUP, CUSTOM_ITEM_GROUP_KEY, CUSTOM_ITEM_GROUP);

        ItemGroupEvents.modifyEntriesEvent(CUSTOM_ITEM_GROUP_KEY)
                .register(itemGroup -> {
                    itemGroup.add(ModItems.MAGIC_DUST);
                    itemGroup.add(ModItems.LIGHTNING_STICK);
                });

        ItemGroupEvents.modifyEntriesEvent(ItemGroups.INGREDIENTS)
                .register((itemGroup) -> itemGroup.add(ModItems.MAGIC_DUST));

        FuelRegistry.INSTANCE.add(ModItems.MAGIC_DUST, 5 * 20);
        CompostingChanceRegistry.INSTANCE.add(ModItems.MAGIC_DUST, 0.3f);
    }

    public static Item register(Item item, String id) {
        Identifier itemID = Identifier.of(CustomItem.MOD_ID, id);
        Item registeredItem = Registry.register(Registries.ITEM, itemID, item);
        return registeredItem;
    }
}
