package com.example.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ShapeContext;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.text.Text;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Formatting;
import net.minecraft.util.hit.BlockHitResult;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.shape.VoxelShape;
import net.minecraft.util.shape.VoxelShapes;
import net.minecraft.world.BlockView;
import net.minecraft.world.World;

public class ExplodingBlock extends Block {
    public ExplodingBlock(Settings settings) {
        super(settings);
    }

    private static final VoxelShape BOTTOM_SHAPE = Block.createCuboidShape(0, 0, 0, 16, 8, 16);
    private static final VoxelShape TOP_SHAPE = Block.createCuboidShape(4, 8, 4, 12, 16, 12);
    private static final VoxelShape SHAPE = VoxelShapes.union(BOTTOM_SHAPE, TOP_SHAPE);

    @Override
    protected VoxelShape getOutlineShape(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        return SHAPE;
    }

    @Override
    protected ActionResult onUse(BlockState state, World world, BlockPos pos, PlayerEntity player, BlockHitResult hit) {
        if (world.isClient) {
            return ActionResult.PASS;
        }

        player.sendMessage(Text.empty()
                .append(Text.literal("Ahoj, ").formatted(Formatting.RED, Formatting.UNDERLINE))
                .append(Text.literal(player.getName().getString()).formatted(Formatting.AQUA))
                .append(Text.literal(", vítej!").formatted(Formatting.GOLD)), true);

        world.createExplosion(null, pos.getX(), pos.getY(), pos.getZ(), 10f, true, World.ExplosionSourceType.BLOCK);

        return ActionResult.SUCCESS;
    }
}
