package com.example.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.server.world.ServerWorld;
import net.minecraft.state.StateManager;
import net.minecraft.state.property.BooleanProperty;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Box;
import net.minecraft.util.math.random.Random;
import net.minecraft.world.World;

public class LauncherBlock extends Block {
    public LauncherBlock(Settings settings) {
        super(settings);
        setDefaultState(getDefaultState().with(COOLDOWN, false));
    }

    public static final BooleanProperty COOLDOWN = BooleanProperty.of("cooldown");

    @Override
    protected void appendProperties(StateManager.Builder<Block, BlockState> builder) {
        builder.add(COOLDOWN);
        super.appendProperties(builder);
    }

    private final int cooldownTicks = 40;
    private int timer = 0;

    @Override
    protected void scheduledTick(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (timer > 0) {
            timer--;
            world.scheduleBlockTick(pos, this, 0);
        } else if (!world.isReceivingRedstonePower(pos)) {
            world.setBlockState(pos, state.with(COOLDOWN, false));
        } else {
            world.scheduleBlockTick(pos, this, 0);
        }

        super.scheduledTick(state, world, pos, random);
    }

    @Override
    protected void neighborUpdate(BlockState state, World world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        if (!world.isReceivingRedstonePower(pos)) {
            return;
        }

        if (state.get(COOLDOWN)) {
            return;
        }

        Box box = new Box(pos.up());
        var entityList = world.getEntitiesByClass(Entity.class, box, Entity::isOnGround);
        for (var entity : entityList) {
            entity.addVelocity(0, 1, 0);
            entity.velocityModified = true;
        }

        timer = cooldownTicks;
        world.setBlockState(pos, state.with(COOLDOWN, true));
        world.scheduleBlockTick(pos, this, 0);

        super.neighborUpdate(state, world, pos, sourceBlock, sourcePos, notify);
    }
}
