package com.example.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Box;
import net.minecraft.world.World;

public class LauncherBlock extends Block {
    public LauncherBlock(Settings settings) {
        super(settings);
    }

    @Override
    protected void neighborUpdate(BlockState state, World world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        if (!world.isReceivingRedstonePower(pos)) {
            return;
        }

        Box box = new Box(pos.up());
        var entityList = world.getEntitiesByClass(Entity.class, box, Entity::isOnGround);
        for (var entity : entityList) {
            entity.addVelocity(0, 1, 0);
            entity.velocityModified = true;
        }

        super.neighborUpdate(state, world, pos, sourceBlock, sourcePos, notify);
    }
}
