package com.example.item;

import com.google.common.collect.Lists;
import net.minecraft.entity.Entity;
import net.minecraft.entity.mob.CreeperEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Box;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class AntiCreeperItem extends Item {
    public AntiCreeperItem(Settings settings) {
        super(settings);
    }

    @Override
    public void inventoryTick(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        if (!entity.isPlayer()) {
            return;
        }

        var player = (PlayerEntity) entity;
        var items = player.getHandItems().iterator();
        var isItemInHand = Lists.newArrayList(items).contains(stack);
        if (!isItemInHand) {
            return;
        }

        var playerPos = player.getPos();
        var distance = new Vec3d(10, 10, 10);
        var box = new Box(playerPos.subtract(distance), playerPos.add(distance));

        var creepers = world.getEntitiesByClass(CreeperEntity.class, box,
                creeperEntity -> creeperEntity.distanceTo(player) < 10);

        for (var creeper : creepers) {
            creeper.setFuseSpeed(-1);
        }
    }
}
