package com.example.item;


import net.minecraft.entity.EntityType;
import net.minecraft.entity.LightningEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.TypedActionResult;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Heightmap;
import net.minecraft.world.World;

public class LightningStick extends Item {
    public LightningStick(Settings settings) {
        super(settings);
    }

    @Override
    public TypedActionResult<ItemStack> use(World world, PlayerEntity user, Hand hand) {
        if (world.isClient) {
            return TypedActionResult.pass(user.getStackInHand(hand));
        }

        var offset = Vec3d.fromPolar(user.getPitch(), user.getYaw())
                .normalize().multiply(10);

        var pos = user.getEyePos().add(offset);

        BlockPos blockPos = BlockPos.ofFloored(pos);
        blockPos = world.getTopPosition(Heightmap.Type.MOTION_BLOCKING, blockPos);

        LightningEntity lightning = new LightningEntity(EntityType.LIGHTNING_BOLT, world);

        lightning.setPosition(blockPos.toCenterPos());
        world.spawnEntity(lightning);
        world.createExplosion(lightning, blockPos.getX(), blockPos.getY(), blockPos.getZ(), 1f,true, World.ExplosionSourceType.MOB);

        return TypedActionResult.success(user.getStackInHand(hand));
    }
}
