package com.example.block;

import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.item.*;
import net.minecraft.registry.Registries;
import net.minecraft.registry.Registry;
import net.minecraft.registry.RegistryKey;
import net.minecraft.registry.RegistryKeys;
import net.minecraft.util.Identifier;

public class ModBlocks {
    public static final RegistryKey<Block> CONDENSED_DIRT_KEY = RegistryKey.of(
            RegistryKeys.BLOCK,
            Identifier.of(CustomBlock.MOD_ID, "condensed_dirt")
    );

    public static final Block CONDENSED_DIRT = register(
            new Block(AbstractBlock.Settings.create()
                    .requiresTool()
                    .strength(3.0f, 6.0f)),
            CONDENSED_DIRT_KEY,
            true
    );

    public static final RegistryKey<Block> CUSTOM_TEXTURE_KEY = RegistryKey.of(
            RegistryKeys.BLOCK,
            Identifier.of(CustomBlock.MOD_ID, "custom_texture")
    );

    public static final Block CUSTOM_TEXTURE = register(
            new Block(AbstractBlock.Settings.create()),
            CUSTOM_TEXTURE_KEY,
            true
    );


    public static void initialize() {
        ItemGroupEvents.modifyEntriesEvent(ItemGroups.NATURAL)
                .register(group -> {
                    group.addAfter(Items.DIRT, CONDENSED_DIRT.asItem());
                });
    }

    public static Block register(Block block, RegistryKey<Block> blockKey, boolean registerItem) {
        if (registerItem) {
            var itemKey = RegistryKey.of(RegistryKeys.ITEM, blockKey.getValue());
            BlockItem blockItem = new BlockItem(block, new Item.Settings());
            Registry.register(Registries.ITEM, itemKey, blockItem);
        }

        return Registry.register(Registries.BLOCK, blockKey, block);
    }
}
